VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cPagePreview"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'the Declarations below are for the handling of our internal PixelSurface,
'used for the cairo-based "Pixel-Preview" in the GUI - our internal mPixelSurface below will be
'filled-up with the current page-content - and after that it is rendered on *top* of the "normal" ucCanvas-Surface
'(which in this Demo is only responsible, to render the darker-grey Background-Color, all the "interesting stuff" is rendered here)
Private mPixelSurface As cCairoSurface, mPixelCC As cCairoContext
Private mContainerPixelWidth As Long, mContainerPixelHeight As Long
Private mSrfOffsX As Long, mSrfOffsY As Long, mSrfDX As Long, mSrfDY As Long

'and the line below is related to the Pointsize-Handling, which matches the PDF-Surfaces Page-Dimensions
Private mPageWidthPoints As Long, mPageHeightPoints As Long

Public Sub SetPageDimensions(ByVal PageWidthPoints As Long, ByVal PageHeightPoints As Long)
  
  If PageWidthPoints < 30 Then mPageWidthPoints = 30 Else mPageWidthPoints = PageWidthPoints
  If PageHeightPoints < 30 Then mPageHeightPoints = 30 Else mPageHeightPoints = PageHeightPoints
    
  SetPixelSurfaceDimensions mContainerPixelWidth, mContainerPixelHeight
End Sub

Public Property Get PageWidthPoints() As Long
  PageWidthPoints = mPageWidthPoints
End Property
Public Property Get PageHeightPoints() As Long
  PageHeightPoints = mPageHeightPoints
End Property

Public Sub SetPixelSurfaceDimensions(ByVal ContainerPixelWidth As Long, ByVal ContainerPixelHeight As Long)
Dim AspectRatio As Double
  'let's buffer the Container-Dimensions here in appropriate Private-Vars
  If ContainerPixelWidth < 50 Then mContainerPixelWidth = 50 Else mContainerPixelWidth = ContainerPixelWidth
  If ContainerPixelHeight < 50 Then mContainerPixelHeight = 50 Else mContainerPixelHeight = ContainerPixelHeight
  
  mSrfOffsX = 0
  mSrfOffsY = 0
  
  AspectRatio = mPageWidthPoints / mPageHeightPoints
  mSrfDX = mContainerPixelWidth
  mSrfDY = mContainerPixelHeight
  If mSrfDY * AspectRatio > mSrfDX Then
    mSrfOffsY = (mSrfDY - mSrfDX / AspectRatio) / 2
    mSrfDY = mSrfDX / AspectRatio
  ElseIf mSrfDX / AspectRatio > mSrfDY Then
    mSrfOffsX = (mSrfDX - mSrfDY * AspectRatio) / 2
    mSrfDX = mSrfDY * AspectRatio
  End If
  
  Set mPixelSurface = Cairo.CreateSurface(1 * mSrfDX, 1 * mSrfDY)
  Set mPixelCC = mPixelSurface.CreateContext
  mPixelCC.ScaleDrawings 1 * mSrfDX / mPageWidthPoints, 1 * mSrfDY / mPageHeightPoints
End Sub

Public Property Get SrfOffsX() As Long
  SrfOffsX = mSrfOffsX
End Property
Public Property Get SrfOffsY() As Long
  SrfOffsY = mSrfOffsY
End Property

Public Property Get SrfWidth() As Long
  SrfWidth = mSrfDX
End Property
Public Property Get SrfHeight() As Long
  SrfHeight = mSrfDY
End Property


Public Property Get PixelSurface() As cCairoSurface
  Set PixelSurface = mPixelSurface
End Property

Public Property Get PixelCC() As cCairoContext
  Set PixelCC = mPixelCC
End Property


Private Sub Class_Initialize()
  mContainerPixelWidth = 210: mContainerPixelHeight = 297
  SetPageDimensions 595, 841 'init with an A4-Sized (non-Landscaped) Page
End Sub
